//
//  WDUtilityDictCat.h
//  SmartWare
//
//  Created by Clark Jackson on 4/1/09.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class WDVolumeModel;
@class WDDeviceModel;

@interface NSMutableDictionary (WDUtilityDictCat)

- (WDVolumeModel*) volumeModelByBSDName:(NSString *)bsdName;
- (WDVolumeModel*) volumeModelByBSDNodeName:(NSString *)bsdNodeName;
- (WDVolumeModel*) volumeModelByVolumeName:(NSString *)volume;
- (WDVolumeModel*) volumeModelByVolumeMountPoint:(NSString *)mountPoint;
- (NSMutableArray *) volumeNamesFromDeviceBSDName:(NSString *)bsdName;
- (NSMutableArray*) arrayOfSortedSerialNumbers;
- (NSString *) bsdNameForSerialNumber:(NSString *)theSerialNumber;
- (WDVolumeModel*) anyUnlockedVolume;
- (BOOL) deviceIsUnlocked:(NSString *)bsdName;
- (WDDeviceModel*) anyDeviceModel;
- (WDVolumeModel*) anyVolumeModel;
- (NSMutableArray*) volumeNames;
- (NSMutableArray*) volumeMountPoints;
- (void) resignAllSourceVolumes;
- (void) resignAllTargetObjects;

@end
